// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : sound.h
// Date           : February 2008
//
// Description    : This file defines the Sound class used to handle all sound
//                  loading and playing.
//
//                  Init() must be called at the beginning of the main program
//                  to ensure all sound data is preloaded before any sounds
//                  are used.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once



#include <vector>
#include <map>
#include <dsound.h>



class Sound 
{

  protected:

    static LPDIRECTSOUND8                               s_pDSound;
    static std::vector<LPDIRECTSOUNDBUFFER>             s_allBuffers;
    static std::map<std::string,LPDIRECTSOUNDBUFFER>    s_mapBuffers;
    static int                                          s_MasterVolume;
    static int                                          s_VolumeRange[101];


    LPDIRECTSOUNDBUFFER                                 m_pBuffer;



    static void                         preloadAllSounds();

  public:

    Sound();
    ~Sound();

    void                                Play();
    void                                Loop();
    void                                Stop();


    static void                         Init( HWND hWnd );
    static void                         Release();
    static void                         SetVolume( int Volume );
    static int                          Volume();

    bool                                IsPlaying() const;

    void                                Duplicate( Sound* pOrigSound );

    bool                                PreloadSound( const char* filename );

};

